function data = dataLoading(opts)
	data = struct();

	% allocate data for world zone
	L = [];     % length
	A = [];     % area 
    MAF = [];   % mean annual flow
	BT = [];    % category

	% get all data
	
	parfor n = 1:numel(opts.zones)
		% load shapefile
		filename = strrep(opts.shapefile, "%ZONE%", opts.zones(n)); 
		shp = struct2table(shaperead(filename));
		
		% filter in lake percent
		shp = shp(shp.INLAKEPERC < opts.inLakePercentLimit, :);

		% save zone data
		data(n).zone = opts.zones(n);
		data(n).length = shp.LENGTH_KM;
		data(n).area = shp.UPLAND_SKM;
        data(n).maf = shp.dis_m3_pyr;
		data(n).class = shp.predcat1;

		% append data for world zone
		L = [L; shp.LENGTH_KM];
		A = [A; shp.UPLAND_SKM];
        MAF = [MAF; shp.dis_m3_pyr];
		BT = [BT; shp.predcat1];

	end

end
